/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import me.decce.gnetum.PerformanceAnalyzer;
import me.decce.gnetum.gui.BaseScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class AnalysisScreen
extends BaseScreen {
    public final PerformanceAnalyzer.Result analysis;
    private List<FormattedCharSequence> lines;

    public AnalysisScreen(PerformanceAnalyzer.Result analysis) {
        this.analysis = analysis;
    }

    @Override
    public void close() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    @Override
    protected void rebuild() {
        super.rebuild();
        String body = this.analysis.getMessages().isEmpty() ? I18n.m_118938_((String)"gnetum.config.analysis.good", (Object[])new Object[0]) : String.join((CharSequence)"\n\n", this.analysis.getMessages());
        StringBuilder data = new StringBuilder();
        long[] durations = this.analysis.getDurations();
        if (durations == null) {
            data.append(I18n.m_118938_((String)"gnetum.config.analysis.failedDuration", (Object[])new Object[0]));
        } else {
            data.append(I18n.m_118938_((String)"gnetum.config.analysis.detailDuration", (Object[])new Object[0]));
            for (int i = 1; i < durations.length; ++i) {
                data.append("\n");
                data.append("Pass [").append(i).append("] - ").append(String.format("%.2f", (double)durations[i] / 1000.0)).append("\u03bcs");
            }
        }
        String str = body + "\n\n" + data.toString();
        int maxWidth = 300;
        this.lines = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)str), maxWidth);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        String title = I18n.m_118938_((String)(this.analysis.getIcon() == PerformanceAnalyzer.ResultIcon.TICK ? "gnetum.config.analysis.title.good" : "gnetum.config.analysis.title.suboptimal"), (Object[])new Object[0]);
        int titleWidth = this.f_96547_.m_92895_(title);
        int xfont = this.f_96543_ / 2 - titleWidth / 2 + 8 + 2;
        int xicon = xfont - 4 - 16;
        int y = this.f_96544_ / 2 - 90;
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.analysis.getIcon().icon());
        AnalysisScreen.m_93133_((PoseStack)poseStack, (int)xicon, (int)(y - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        AnalysisScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)title, (int)xfont, (int)y, (int)0xFFFFFF);
        if (this.lines != null) {
            int n = this.f_96544_ / 2;
            int n2 = this.lines.size();
            Objects.requireNonNull(this.f_96547_);
            int textY = n - n2 * 9 / 2;
            for (FormattedCharSequence line : this.lines) {
                float x = this.f_96543_ / 2 - this.f_96547_.m_92724_(line) / 2;
                this.f_96547_.m_92877_(poseStack, line, x, (float)textY, 0xFFFFFF);
                Objects.requireNonNull(this.f_96547_);
                textY += 9;
            }
        }
    }
}

